
IF NOT EXISTS
(
    SELECT *
    FROM INFORMATION_SCHEMA.TABLES
    WHERE TABLE_NAME = '[ADM_ERRO_CONSOLID_OUTROS_PROCED]'
)
BEGIN
	SET ANSI_NULLS ON;
	SET QUOTED_IDENTIFIER ON;
	CREATE TABLE [dbo].[ADM_ERRO_CONSOLID_OUTROS_PROCED]
	([CD_CONTROLE]  [BIGINT] IDENTITY(1, 1) NOT NULL,
	 [CD_EMP]       [INT] NULL,
	 [CD_FILIAL]    [INT] NULL,
	 [TP_PROC]      VARCHAR (20) NULL,
	 [DT_MOV]       [DATE] NULL,
	 [DT_CAD]       [DATETIME] NULL,
	 [JSON_ENVIADO] VARCHAR (MAX) NULL,
	 [LAUDO]        VARCHAR (500) NULL,
	 CONSTRAINT [PK_ADM_ERRO_CONSOLID_OUTROS_PROCED] PRIMARY KEY CLUSTERED([CD_CONTROLE] ASC)
	 WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	)
	ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
	CREATE NONCLUSTERED INDEX [ADM_ERRO_CONSOLID_OUTROS_PROCED_CDEMP_CDFILIAL_DTMOV] ON [dbo].[ADM_ERRO_CONSOLID_OUTROS_PROCED]([CD_EMP] ASC, [CD_FILIAL] ASC, [DT_MOV] ASC) WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
	CREATE NONCLUSTERED INDEX [ADM_ERRO_CONSOLID_OUTROS_PROCED_DTCAD] ON [dbo].[ADM_ERRO_CONSOLID_OUTROS_PROCED]([DT_CAD] ASC) WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
END;